/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.reloading;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import mod.chiselsandbits.aabb.AABBManager;
import mod.chiselsandbits.api.reloading.ICacheClearingHandler;
import mod.chiselsandbits.change.ChangeTrackerManger;
import mod.chiselsandbits.chiseling.LocalChiselingContextCache;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_3902;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DataReloadingResourceManager
implements class_3302 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DataReloadingResourceManager INSTANCE = new DataReloadingResourceManager();
    private final Set<ICacheClearingHandler> cacheClearingHandlers = Sets.newConcurrentHashSet();

    public static DataReloadingResourceManager getInstance() {
        return INSTANCE;
    }

    private DataReloadingResourceManager() {
    }

    public DataReloadingResourceManager registerCacheClearer(ICacheClearingHandler cacheClearingHandler) {
        this.cacheClearingHandlers.add(cacheClearingHandler);
        return this;
    }

    public void onResourceManagerReload() {
        LOGGER.info("Resetting common caches");
        this.cacheClearingHandlers.forEach(ICacheClearingHandler::clear);
    }

    public void setup() {
        this.cacheClearingHandlers.clear();
        this.registerCacheClearer(AABBManager.getInstance()::clearCache).registerCacheClearer(VoxelShapeManager.getInstance()::clearCache).registerCacheClearer(LocalChiselingContextCache.getInstance()::clearCache).registerCacheClearer(ChangeTrackerManger.getInstance()::clearCache);
    }

    @NotNull
    public CompletableFuture<Void> method_25931(class_3302.class_4045 barrier, @NotNull class_3300 manager, @NotNull class_3695 preparationProfiler, @NotNull class_3695 reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        return barrier.method_18352((Object)class_3902.field_17274).thenRunAsync(() -> {
            reloadProfiler.method_16065();
            reloadProfiler.method_15396("C&B Data reload");
            this.onResourceManagerReload();
            reloadProfiler.method_15407();
            reloadProfiler.method_16066();
        }, gameExecutor);
    }
}

